<?php

namespace PWCSD\NemesiCMS\Admin\Projects\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectBranch extends Model 
{

    protected $table = 'projects_branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function commits()
    {
        return $this->hasMany('ProjectBranchCommit', 'project_branch_id');
    }

    public function database()
    {
        return $this->hasOne('ProjectDatabase', 'project_database_id');
    }

}